/*********************************************************************************************************//**
 * @file    ht32f125x_board.h
 * @version V1.0
 * @date    04/11/2011
 * @brief   HT32F125x target board definition file.
 *************************************************************************************************************
 *
 * <h2><center>Copyright (C) 2011 Holtek Semiconductor Inc. All rights reserved</center></h2>
 *
 ************************************************************************************************************/
#ifndef __HT32F125X_BOARD_H
#define __HT32F125X_BOARD_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------------------------------------*/

/** @addtogroup Utilities
  * @{
  */

/** @addtogroup HT32F125x_Board_Abstraction_Layer
  * @{
  */

/** @defgroup HT32F125x_Board_Exported_Types HT32F125x Board exported types
  * @{
  */
/**
  * @}
  */

/** @defgroup HT32F125x_Board_Exported_Constants HT32F125x Board exported constants
  * @{
  */

/**
  * @brief  Uncomment the line corresponding to the HT32F125x development
  *   board used in your application.
  *
  *  Tip: To avoid modifying this file each time you need to switch between these
  *       boards, you can define the board in your toolchain compiler preprocessor.
  */
#if !defined (USE_HT32F1253_DVB)
 /* #define USE_HT32F1253_DVB */
#endif

#ifdef USE_HT32F1253_DVB
  #include "HT32F1253_DVB\ht32f1253_dvb.h"
#else
 #error "Please select first the USE_HT32F125X board to be used (in ht32f125x_board.h)"
#endif
/**
  * @}
  */ 

/** @defgroup HT32F125x_Board_Exported_Macros HT32F125x Board exported macros
  * @{
  */
/**
  * @}
  */

/** @defgroup HT32F125x_Board_Exported_Functions HT32F125x Board exported functions
  * @{
  */


#ifdef __cplusplus
}
#endif


#endif /* __HT32F125X_BOARD_H */
/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

