/*********************************************************************************************************//**
 * @file    ht32f1253_dvb.h
 * @version V1.0
 * @date    04/11/2011
 * @brief   Header file for ht32f1253_dvb.c module.
 *************************************************************************************************************
 *
 * <h2><center>Copyright (C) 2011 Holtek Semiconductor Inc. All rights reserved</center></h2>
 *
 ************************************************************************************************************/
#ifndef __HT32F1253_DVB_H
#define __HT32F1253_DVB_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------------------------------------*/
#include "ht32f125x.h"
#include "i2c_eeprom.h"
#include "spi_flash.h"
#include "spi_lcd.h"

/** @addtogroup Utilities
  * @{
  */

/** @addtogroup HT32F1253_Development_Board
  * @{
  */

/** @addtogroup HT32F1253_DVB
  * @{
  */

/** @defgroup HT32F1253_DVB_Exported_Types HT32F1253 DVB exported types
  * @{
  */
/**
  * @}
  */

/** @defgroup HT32F1253_DVB_Exported_Constants HT32F1253 DVB exported constants
  * @{
  */

#define DVB_GPIO_NBR                      2
#define DVB_GPIOA_ID                      0
#define DVB_GPIOB_ID                      1

/** @addtogroup HT32F1253_DVB_LED
  * @{
  */
#define LEDn                        3

#define LED1_GPIO_ID                DVB_GPIOA_ID
#define LED1_GPIO_PORT              ((GPIO_TypeDef*)GPIOA_BASE)
#define LED1_GPIO_PIN               GPIO_PIN_5
#define LED1_AFIO_MODE              AFIO_MODE_DEFAULT
#define LED1_AFIO_PIN               AFIO_PIN_5

#define LED2_GPIO_ID                DVB_GPIOA_ID
#define LED2_GPIO_PORT              ((GPIO_TypeDef*)GPIOA_BASE)
#define LED2_GPIO_PIN               GPIO_PIN_6
#define LED2_AFIO_MODE              AFIO_MODE_DEFAULT
#define LED2_AFIO_PIN               AFIO_PIN_6

#define LED3_GPIO_ID                DVB_GPIOB_ID
#define LED3_GPIO_PORT              ((GPIO_TypeDef*)GPIOB_BASE)
#define LED3_GPIO_PIN               GPIO_PIN_12
#define LED3_AFIO_MODE              AFIO_MODE_DEFAULT
#define LED3_AFIO_PIN               AFIO_PIN_12
/**
  * @}
  */

/** @addtogroup HT32F1253_DVB_BUTTON
  * @{
  */
#define BUTTONn                     3

/**
 * @brief Wakeup push-button
 */
#define WAKEUP_BUTTON_GPIO_ID       DVB_GPIOB_ID
#define WAKEUP_BUTTON_GPIO_PORT     ((GPIO_TypeDef*)GPIOB_BASE)
#define WAKEUP_BUTTON_GPIO_PIN      GPIO_PIN_10
#define WAKEUP_BUTTON_AFIO_MODE     AFIO_MODE_1
#define WAKEUP_BUTTON_AFIO_PIN      AFIO_PIN_10

#define WAKEUP_BUTTON_EXTI_CHANNEL  EXTI_CHANNEL_10
#define WAKEUP_BUTTON_AFIO_ESS      AFIO_ESS_PB
#define WAKEUP_BUTTON_AFIO_EXTI_CH  AFIO_EXTI_CH_10
#define WAKEUP_BUTTON_IRQn          EXTI10_IRQn
/**
 * @brief Key1 push-button
 */
#define KEY1_BUTTON_GPIO_ID         DVB_GPIOB_ID
#define KEY1_BUTTON_GPIO_PORT       ((GPIO_TypeDef*)GPIOB_BASE)
#define KEY1_BUTTON_GPIO_PIN        GPIO_PIN_11
#define KEY1_BUTTON_AFIO_MODE       AFIO_MODE_DEFAULT
#define KEY1_BUTTON_AFIO_PIN        AFIO_PIN_11

#define KEY1_BUTTON_EXTI_CHANNEL    EXTI_CHANNEL_11
#define KEY1_BUTTON_AFIO_ESS        AFIO_ESS_PB
#define KEY1_BUTTON_AFIO_EXTI_CH    AFIO_EXTI_CH_11
#define KEY1_BUTTON_IRQn            EXTI11_IRQn

/**
 * @brief Key2 push-button
 */
#define KEY2_BUTTON_GPIO_ID         DVB_GPIOA_ID
#define KEY2_BUTTON_GPIO_PORT       ((GPIO_TypeDef*)GPIOA_BASE)
#define KEY2_BUTTON_GPIO_PIN        GPIO_PIN_10
#define KEY2_BUTTON_AFIO_MODE       AFIO_MODE_DEFAULT
#define KEY2_BUTTON_AFIO_PIN        AFIO_PIN_10

#define KEY2_BUTTON_EXTI_CHANNEL    EXTI_CHANNEL_10
#define KEY2_BUTTON_AFIO_ESS        AFIO_ESS_PA
#define KEY2_BUTTON_AFIO_EXTI_CH    AFIO_EXTI_CH_10
#define KEY2_BUTTON_IRQn            EXTI10_IRQn
/**
  * @}
  */

/** @addtogroup HT32F1253_DVB_BUZZER
  * @{
  */
#define BUZZER_GPIO_ID         DVB_GPIOB_ID
#define BUZZER_GPIO_PORT       ((GPIO_TypeDef*)GPIOB_BASE)
#define BUZZER_GPIO_PIN        GPIO_PIN_2
#define BUZZER_AFIO_MODE       AFIO_MODE_3
#define BUZZER_AFIO_PIN        AFIO_PIN_2

#define BUZZER_GPTM            ((GPTM_TypeDef*)GPTM1_BASE)
#define BUZZER_BUZZER_CLK      CKCU_APBEN1_GPTM1
#define BUZZER_GPTM_CHANNEL    GPTM_CH_0
#define BUZZER_IRQn            GPTM1_IRQn
/**
  * @}
  */

/** @addtogroup HT32F1253_DVB_COM
  * @{
  */
#define COMn                             1

/**
 * @brief Definition for COM port1, connected to USART
 */
#define DVB_COM1_USART              ((USART_TypeDef*)USART_BASE)
#define DVB_COM1_CLK                CKCU_APBEN0_USART

#define DVB_COM1_TX_GPIO_ID         DVB_GPIOA_ID
#define DVB_COM1_TX_AFIO_MODE       AFIO_MODE_2
#define DVB_COM1_TX_AFIO_PIN        AFIO_PIN_9

#define DVB_COM1_RX_GPIO_ID         DVB_GPIOA_ID
#define DVB_COM1_RX_AFIO_MODE       AFIO_MODE_2
#define DVB_COM1_RX_AFIO_PIN        AFIO_PIN_8

#define DVB_COM1_IRQn               USART_IRQn
/**
  * @}
  */

/** @addtogroup HT32F1253_DVB_SPI_FLASH
  * @{
  */

/**
 * @brief SPI Flash interface pins
 */
#define FLASH_SPI                       ((SPI_TypeDef*)SPI_BASE)

#define FLASH_SPI_CLK                   CKCU_APBEN0_SPI

#define FLASH_SPI_SEL_GPIO_ID           DVB_GPIOB_ID
#define FLASH_SPI_SEL_GPIO_PORT         ((GPIO_TypeDef*)GPIOB_BASE)
#define FLASH_SPI_SEL_GPIO_PIN          GPIO_PIN_7
#define FLASH_SPI_SEL_AFIO_MODE         AFIO_MODE_DEFAULT
#define FLASH_SPI_SEL_AFIO_PIN          AFIO_PIN_7

#define FLASH_SPI_SCK_GPIO_ID           DVB_GPIOB_ID
#define FLASH_SPI_SCK_AFIO_MODE         AFIO_MODE_1
#define FLASH_SPI_SCK_AFIO_PIN          AFIO_PIN_13

#define FLASH_SPI_MISO_GPIO_ID          DVB_GPIOB_ID
#define FLASH_SPI_MISO_AFIO_MODE        AFIO_MODE_1
#define FLASH_SPI_MISO_AFIO_PIN         AFIO_PIN_14

#define FLASH_SPI_MOSI_GPIO_ID          DVB_GPIOB_ID
#define FLASH_SPI_MOSI_AFIO_MODE        AFIO_MODE_1
#define FLASH_SPI_MOSI_AFIO_PIN         AFIO_PIN_15
/**
  * @}
  */

/** @addtogroup HT32F1755_2755_DVB_SPI_LCD
  * @{
  */

/**
 * @brief SPI LCD interface pins
 */
#define LCD_SPI                       ((SPI_TypeDef*)SPI_BASE)

#define LCD_SPI_CLK                   CKCU_APBEN0_SPI

#define LCD_SPI_SEL_GPIO_ID           DVB_GPIOB_ID
#define LCD_SPI_SEL_GPIO_PORT         ((GPIO_TypeDef*)GPIOB_BASE)
#define LCD_SPI_SEL_GPIO_PIN          GPIO_PIN_6
#define LCD_SPI_SEL_AFIO_MODE         AFIO_MODE_DEFAULT
#define LCD_SPI_SEL_AFIO_PIN          AFIO_PIN_6

#define LCD_SPI_SCK_GPIO_ID           DVB_GPIOB_ID
#define LCD_SPI_SCK_GPIO_PORT         ((GPIO_TypeDef*)GPIOB_BASE)
#define LCD_SPI_SCK_AFIO_MODE         AFIO_MODE_1
#define LCD_SPI_SCK_AFIO_PIN          AFIO_PIN_13

#define LCD_SPI_MOSI_GPIO_ID          DVB_GPIOB_ID
#define LCD_SPI_MOSI_GPIO_PIN         GPIO_PIN_15
#define LCD_SPI_MOSI_AFIO_MODE        AFIO_MODE_1
#define LCD_SPI_MOSI_AFIO_PIN         AFIO_PIN_15

#define LCD_SPI_MISO_GPIO_ID          DVB_GPIOB_ID
#define LCD_SPI_MISO_AFIO_MODE        AFIO_MODE_1
#define LCD_SPI_MISO_AFIO_PIN         AFIO_PIN_14

#define LCD_SPI_BL_GPIO_ID            DVB_GPIOB_ID
#define LCD_SPI_BL_GPIO_PORT          ((GPIO_TypeDef*)GPIOB_BASE)
#define LCD_SPI_BL_GPIO_PIN           GPIO_PIN_4
#define LCD_SPI_BL_AFIO_MODE          AFIO_MODE_DEFAULT
#define LCD_SPI_BL_AFIO_PIN           AFIO_PIN_4

#define LCD_SPI_RESET_GPIO_ID         DVB_GPIOB_ID
#define LCD_SPI_RESET_GPIO_PORT       ((GPIO_TypeDef*)GPIOB_BASE)
#define LCD_SPI_RESET_GPIO_PIN        GPIO_PIN_3
#define LCD_SPI_RESET_AFIO_MODE       AFIO_MODE_DEFAULT
#define LCD_SPI_RESET_AFIO_PIN        AFIO_PIN_3
/**
  * @}
  */

/** @addtogroup HT32F1253_DVB_I2C_EEPROM
  * @{
  */

/**
 * @brief I2C EEPROM interface pins
 */
#define EEPROM_24C64

#define EEPROM_I2C                      ((I2C_TypeDef*)I2C_BASE)

#define EEPROM_I2C_CLK                  CKCU_APBEN0_I2C

#define EEPROM_I2C_SCL_GPIO_ID          DVB_GPIOA_ID
#define EEPROM_I2C_SCL_AFIO_MODE        AFIO_MODE_1
#define EEPROM_I2C_SCL_AFIO_PIN         AFIO_PIN_11

#define EEPROM_I2C_SDA_GPIO_ID          DVB_GPIOA_ID
#define EEPROM_I2C_SDA_AFIO_MODE        AFIO_MODE_1
#define EEPROM_I2C_SDA_AFIO_PIN         AFIO_PIN_12
/**
  * @}
  */

typedef enum
{
  LED1 = 0,
  LED2 = 1,
  LED3 = 2
} LED_TypeDef;

typedef enum
{
  BUTTON_WAKEUP = 0,
  BUTTON_KEY1 = 1,
  BUTTON_KEY2 = 2
} BUTTON_TypeDef;

typedef enum
{
  BUTTON_MODE_GPIO = 0,
  BUTTON_MODE_EXTI = 1
} BUTTON_MODE_TypeDef;

typedef enum
{
  COM1 = 0
} COM_TypeDef;

/**
  * @}
  */

/** @defgroup HT32F1253_DVB_Exported_Macros HT32F1253 DVB exported macros
  * @{
  */
/**
  * @}
  */

/** @defgroup HT32F1253_DVB_Exported_Functions HT32F1253 DVB exported functions
  * @{
  */
void HT32F_DVB_GPxConfig(u8 GPIO_ID, u32 AFIO_PIN, u32 AFIO_MODE);
void HT32F_DVB_LEDInit(LED_TypeDef Led);
void HT32F_DVB_LEDOn(LED_TypeDef Led);
void HT32F_DVB_LEDOff(LED_TypeDef Led);
void HT32F_DVB_LEDToggle(LED_TypeDef Led);
void HT32F_DVB_PBInit(BUTTON_TypeDef Button, BUTTON_MODE_TypeDef Button_Mode);
u32 HT32F_DVB_PBGetState(BUTTON_TypeDef Button);
void HT32F_DVB_COMInit(COM_TypeDef COM, USART_InitTypeDef* USART_InitStruct);

void HT32F_DVB_BuzzerInit(u16 hFreq, u8 bDuty);
void HT32F_DVB_BuzzerConfig(u16 hFreq, u8 bDuty);
void HT32F_DVB_BuzzerOutputCmd(GPTM_CHCTL_Enum Control);

#ifdef __cplusplus
}
#endif


#endif /* __HT32F1253_DVB_H */
/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

