/*********************************************************************************************************//**
 * @file    picture.h
 * @version V1.0
 * @date    09/08/2011
 * @brief   This file contains all the LCD fonts size definition..
 *************************************************************************************************************
 *
 * <h2><center>Copyright (C) 2011 Holtek Semiconductor Inc. All rights reserved</center></h2>
 *
 ************************************************************************************************************/

/* ASCII Table: each character is 16 column (16 dots large) and 24 raw (24 dots high) */
#define Font_Column  16
#define Font_Raw     24

u16 ASCII_Font_Table[] =
       {
        /* Space ' ' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '!' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x01C0, 0x01C0, 0x01C0, 0x01C0,
        0x01C0, 0x01C0, 0x01C0, 0x01C0,
        0x01C0, 0x0080, 0x0080, 0x0000,
        0x01C0, 0x01C0, 0x01C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '"' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0770, 0x0770, 0x0770, 0x0770,
        0x0770, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '#' */
        0x0000, 0x0000, 0x3300, 0x3300,
        0x1980, 0x1980, 0x1980, 0x0CC0,
        0x7FFE, 0x7FFE, 0x0CC0, 0x0EE0,
        0x0660, 0x7FFE, 0x7FFE, 0x0660,
        0x0770, 0x0330, 0x0330, 0x0198,
        0x0198, 0x0000, 0x0000, 0x0000,
        /* '$' */
        0x0000, 0x0000, 0x0000, 0x0080,
        0x03E0, 0x07F0, 0x0EB8, 0x0EB8,
        0x00B8, 0x00F8, 0x01F0, 0x07E0,
        0x0F80, 0x0E80, 0x0E80, 0x0EB8,
        0x0EB8, 0x07F0, 0x03E0, 0x0080,
        0x0080, 0x0000, 0x0000, 0x0000,
        /* '%' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0C1E, 0x063E, 0x0633, 0x0633,
        0x0333, 0x0333, 0x01BE, 0x019E,
        0x3CC0, 0x7EC0, 0x6660, 0x6660,
        0x6660, 0x6630, 0x7E30, 0x3C18,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '&' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x03C0, 0x07E0, 0x0E70, 0x0E70,
        0x0EF0, 0x07E0, 0x03E0, 0x03F0,
        0x33F8, 0x3F3C, 0x3F1C, 0x1E1C,
        0x3F3C, 0x7FF8, 0x23F0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* ''' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x01C0, 0x01C0, 0x01C0, 0x01C0,
        0x01C0, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '(' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0300, 0x0180, 0x0180, 0x01C0,
        0x01C0, 0x00E0, 0x00E0, 0x00E0,
        0x00E0, 0x00E0, 0x00E0, 0x00E0,
        0x00E0, 0x00C0, 0x01C0, 0x01C0,
        0x0180, 0x0180, 0x0300, 0x0000,
        /* ')' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x00C0, 0x0180, 0x0180, 0x0380,
        0x0380, 0x0700, 0x0700, 0x0700,
        0x0700, 0x0700, 0x0700, 0x0700,
        0x0700, 0x0300, 0x0380, 0x0380,
        0x0180, 0x0180, 0x00C0, 0x0000,
        /* '*' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0180, 0x05A0, 0x0DB0, 0x1FF8,
        0x07E0, 0x03C0, 0x0660, 0x0E70,
        0x0660, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '+' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x01C0, 0x01C0,
        0x01C0, 0x01C0, 0x1FFC, 0x1FFC,
        0x1FFC, 0x01C0, 0x01C0, 0x01C0,
        0x01C0, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* ',' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x01C0, 0x01C0, 0x01C0, 0x0100,
        0x0180, 0x00C0, 0x0000, 0x0000,
        /* '-' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0FF0, 0x0FF0, 0x0FF0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '.' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x01C0, 0x01C0, 0x01C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '/' */
        0x0000, 0x0000, 0x0000, 0x0C00,
        0x0C00, 0x0C00, 0x0600, 0x0600,
        0x0600, 0x0700, 0x0300, 0x0300,
        0x0300, 0x0180, 0x0180, 0x0180,
        0x0180, 0x00C0, 0x00C0, 0x0060,
        0x0060, 0x0060, 0x0000, 0x0000,
        /* '0' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x03E0, 0x07F0, 0x0FF8, 0x0E38,
        0x0E38, 0x0E38, 0x0E38, 0x0E38,
        0x0E38, 0x0E38, 0x0E38, 0x0E38,
        0x0FF8, 0x07F0, 0x03E0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '1' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0700, 0x0700, 0x0780, 0x07E0,
        0x07F0, 0x0770, 0x0710, 0x0700,
        0x0700, 0x0700, 0x0700, 0x0700,
        0x0700, 0x0700, 0x0700, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '2' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x03F0, 0x07F8, 0x0E38, 0x0E3C,
        0x0E1C, 0x0E00, 0x0700, 0x0780,
        0x03C0, 0x01C0, 0x00E0, 0x00F0,
        0x0070, 0x0FF8, 0x0FF8, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '3' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x03E0, 0x07F0, 0x0E38, 0x0E38,
        0x0E00, 0x0F00, 0x07C0, 0x07C0,
        0x0F00, 0x0E00, 0x0E00, 0x0E38,
        0x0E38, 0x07F0, 0x03E0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '4' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0E00, 0x0F00, 0x0F00, 0x0F80,
        0x0F80, 0x0EC0, 0x0E60, 0x0E60,
        0x0E30, 0x0E18, 0x3FFC, 0x3FFC,
        0x0E00, 0x0E00, 0x0E00, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '5' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x07E0, 0x07E0, 0x0070, 0x0070,
        0x0070, 0x03F0, 0x07F8, 0x0F38,
        0x0E00, 0x0E00, 0x0E00, 0x0E38,
        0x0778, 0x07F0, 0x03E0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '6' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x03C0, 0x07F0, 0x0F70, 0x0638,
        0x0038, 0x03B8, 0x07F8, 0x0F78,
        0x0E38, 0x0E38, 0x0E38, 0x0E38,
        0x0770, 0x07F0, 0x01C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '7' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0FF8, 0x0FF8, 0x0E00, 0x0700,
        0x0380, 0x0380, 0x01C0, 0x01C0,
        0x00E0, 0x00E0, 0x00E0, 0x0070,
        0x0070, 0x0070, 0x0070, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '8' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x03E0, 0x07F0, 0x0E38, 0x0E38,
        0x0E38, 0x0770, 0x03E0, 0x03E0,
        0x0770, 0x0E38, 0x0E38, 0x0E38,
        0x0F78, 0x07F0, 0x03E0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '9' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0380, 0x0FE0, 0x0EE0, 0x1C70,
        0x1C70, 0x1C70, 0x1C70, 0x1EF0,
        0x1FE0, 0x1DC0, 0x1C00, 0x1C60,
        0x0EF0, 0x0FE0, 0x03C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* ':' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x01C0, 0x01C0, 0x01C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x01C0, 0x01C0, 0x01C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* ';' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0380, 0x0380, 0x0380, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0380, 0x0380, 0x0380, 0x0200,
        0x0300, 0x0180, 0x0000, 0x0000,
        /* '<' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x1000, 0x1C00,
        0x1F80, 0x07E0, 0x00F8, 0x003C,
        0x01F8, 0x0FE0, 0x1F80, 0x1C00,
        0x1000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '=' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x3FFC, 0x3FFC, 0x3FFC, 0x0000,
        0x0000, 0x3FFC, 0x3FFC, 0x3FFC,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '>' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0008, 0x0038,
        0x01F8, 0x07E0, 0x1F00, 0x3C00,
        0x1F80, 0x07F0, 0x01F8, 0x0038,
        0x0008, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '?' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x07E0, 0x0FF0, 0x1E78, 0x1C38,
        0x1C00, 0x1E00, 0x0F00, 0x0780,
        0x03C0, 0x01C0, 0x01C0, 0x0000,
        0x01C0, 0x01C0, 0x01C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '@' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0FC0, 0x3FF8, 0x703C, 0xE00E,
        0xDDC6, 0x8DE2, 0x8FF3, 0x8E71,
        0x8E39, 0x8E39, 0xC639, 0xC739,
        0x67F9, 0x3FF1, 0x1E61, 0x8007,
        0xC00E, 0xF03C, 0x7FF8, 0x1FE0,
        /* 'A' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x07C0, 0x07C0, 0x07C0, 0x0EE0,
        0x0EE0, 0x0EE0, 0x1C60, 0x1C70,
        0x1C70, 0x1FF0, 0x3FF8, 0x3FF8,
        0x3838, 0x701C, 0x701E, 0xE006,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'B' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x07FC, 0x0FFC, 0x1FFC, 0x1C1C,
        0x1C1C, 0x1C1C, 0x0FFC, 0x0FFC,
        0x1FFC, 0x381C, 0x381C, 0x381C,
        0x3FFC, 0x1FFC, 0x0FFC, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'C' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x07C0, 0x1FF0, 0x1FF8, 0x3C38,
        0x183C, 0x001C, 0x001C, 0x001C,
        0x001C, 0x001C, 0x183C, 0x3C38,
        0x1FF8, 0x1FF0, 0x07C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'D' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x07FC, 0x0FFC, 0x1FFC, 0x1C1C,
        0x3C1C, 0x381C, 0x381C, 0x381C,
        0x381C, 0x381C, 0x381C, 0x1C1C,
        0x1FFC, 0x0FFC, 0x03FC, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'E' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x1FFC, 0x1FFC, 0x1FFC, 0x001C,
        0x001C, 0x001C, 0x0FFC, 0x0FFC,
        0x0FFC, 0x001C, 0x001C, 0x001C,
        0x1FFC, 0x1FFC, 0x1FFC, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'F' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x1FF8, 0x1FF8, 0x1FF8, 0x0038,
        0x0038, 0x0038, 0x0FF8, 0x0FF8,
        0x0FF8, 0x0038, 0x0038, 0x0038,
        0x0038, 0x0038, 0x0038, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'G' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x07C0, 0x1FF0, 0x3FF8, 0x783C,
        0x301E, 0x000E, 0x000E, 0x7F0E,
        0x7F0E, 0x7F0E, 0x701C, 0x783C,
        0x7FF8, 0x3FF0, 0x07C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'H' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x381C, 0x381C, 0x381C, 0x381C,
        0x381C, 0x381C, 0x3FFC, 0x3FFC,
        0x3FFC, 0x381C, 0x381C, 0x381C,
        0x381C, 0x381C, 0x381C, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'I' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x01C0, 0x01C0, 0x01C0, 0x01C0,
        0x01C0, 0x01C0, 0x01C0, 0x01C0,
        0x01C0, 0x01C0, 0x01C0, 0x01C0,
        0x01C0, 0x01C0, 0x01C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'J' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x1C00, 0x1C00, 0x1C00, 0x1C00,
        0x1C00, 0x1C00, 0x1C00, 0x1C00,
        0x1C00, 0x1C38, 0x1C38, 0x1C78,
        0x1FF0, 0x0FF0, 0x03C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'K' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x3C1C, 0x1E1C, 0x0F1C, 0x071C,
        0x039C, 0x03DC, 0x03FC, 0x07FC,
        0x077C, 0x0E3C, 0x0E1C, 0x1C1C,
        0x1C1C, 0x381C, 0x381C, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'L' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0038, 0x0038, 0x0038, 0x0038,
        0x0038, 0x0038, 0x0038, 0x0038,
        0x0038, 0x0038, 0x0038, 0x0038,
        0x3FF8, 0x3FF8, 0x3FF8, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'M' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x7C1F, 0x7C1F, 0x7C1F, 0x7637,
        0x7637, 0x7637, 0x7777, 0x7777,
        0x7367, 0x7367, 0x73E7, 0x73E7,
        0x71C7, 0x71C7, 0x71C7, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'N' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x381C, 0x383C, 0x387C, 0x387C,
        0x38FC, 0x38DC, 0x39DC, 0x399C,
        0x3B9C, 0x3B1C, 0x3F1C, 0x3E1C,
        0x3E1C, 0x3C1C, 0x381C, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'O' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x07E0, 0x1FF8, 0x3FFC, 0x3C3C,
        0x781E, 0x700E, 0x700E, 0x700E,
        0x700E, 0x700E, 0x781E, 0x3C3C,
        0x3FFC, 0x1FF8, 0x07E0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'P' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x07FC, 0x0FFC, 0x1FFC, 0x1C1C,
        0x1C1C, 0x1C1C, 0x1FFC, 0x0FFC,
        0x07FC, 0x001C, 0x001C, 0x001C,
        0x001C, 0x001C, 0x001C, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'Q' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x07E0, 0x1FF8, 0x3FFC, 0x3C3C,
        0x781E, 0x700E, 0x700E, 0x700E,
        0x700E, 0x710E, 0x7B9E, 0x3F3C,
        0x3FFC, 0x7FF8, 0xF7E0, 0x6000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'R' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x07FC, 0x0FFC, 0x1FFC, 0x1C1C,
        0x1C1C, 0x1C1C, 0x1FFC, 0x0FFC,
        0x03FC, 0x079C, 0x0F1C, 0x0E1C,
        0x1E1C, 0x1C1C, 0x3C1C, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'S' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x03E0, 0x0FF8, 0x0FF8, 0x1E3C,
        0x1C1C, 0x003C, 0x01F8, 0x0FF0,
        0x0FC0, 0x1E00, 0x1C1C, 0x1E3C,
        0x1FF8, 0x0FF8, 0x03E0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'T' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x3FFC, 0x3FFC, 0x3FFC, 0x03C0,
        0x03C0, 0x03C0, 0x03C0, 0x03C0,
        0x03C0, 0x03C0, 0x03C0, 0x03C0,
        0x03C0, 0x03C0, 0x03C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'U' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x381C, 0x381C, 0x381C, 0x381C,
        0x381C, 0x381C, 0x381C, 0x381C,
        0x381C, 0x381C, 0x381C, 0x3C3C,
        0x1FF8, 0x1FF8, 0x07E0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'V' */
        0x0000, 0x0000, 0x0000, 0x600E,
        0x701E, 0x701C, 0x3838, 0x3838,
        0x3838, 0x1C70, 0x1C70, 0x1C70,
        0x0EE0, 0x0EE0, 0x0EE0, 0x07C0,
        0x07C0, 0x07C0, 0x0380, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'W' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x8383, 0x8383, 0xC7C7, 0xC7C7,
        0xC6C7, 0xC6C7, 0xEEEE, 0xEEEE,
        0xEC6E, 0xEC6E, 0xFC7C, 0x7C7C,
        0x7C7C, 0x783C, 0x783C, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'X' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x1C1C, 0x1C1C, 0x0E38, 0x0770,
        0x0770, 0x03E0, 0x03E0, 0x01C0,
        0x03E0, 0x03E0, 0x0770, 0x0770,
        0x0E38, 0x1C1C, 0x1C1C, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'Y' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x380E, 0x380E, 0x1C1C, 0x0E38,
        0x0E38, 0x0770, 0x03E0, 0x03E0,
        0x01C0, 0x01C0, 0x01C0, 0x01C0,
        0x01C0, 0x01C0, 0x01C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'Z' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x3FFC, 0x3FFC, 0x3FFC, 0x1E00,
        0x0F00, 0x0780, 0x0380, 0x01C0,
        0x00E0, 0x00F0, 0x0078, 0x003C,
        0x3FFC, 0x3FFC, 0x3FFC, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '[' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x03E0, 0x03E0, 0x03E0, 0x00E0,
        0x00E0, 0x00E0, 0x00E0, 0x00E0,
        0x00E0, 0x00E0, 0x00E0, 0x00E0,
        0x00E0, 0x00E0, 0x00E0, 0x00E0,
        0x03E0, 0x03E0, 0x03E0, 0x0000,
        /* '\' */
        0x0000, 0x0030, 0x0030, 0x0060,
        0x0060, 0x0060, 0x00C0, 0x00C0,
        0x00C0, 0x00C0, 0x0180, 0x0180,
        0x0180, 0x0380, 0x0300, 0x0300,
        0x0300, 0x0600, 0x0600, 0x0600,
        0x0C00, 0x0C00, 0x0C00, 0x0000,
        /* ']' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x07C0, 0x07C0, 0x07C0, 0x0700,
        0x0700, 0x0700, 0x0700, 0x0700,
        0x0700, 0x0700, 0x0700, 0x0700,
        0x0700, 0x0700, 0x0700, 0x0700,
        0x07C0, 0x07C0, 0x07C0, 0x0000,
        /* '^' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0180, 0x03C0, 0x03C0, 0x07E0,
        0x0660, 0x0E70, 0x0E70, 0x1C38,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '_' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x7FFE, 0x7FFE, 0x0000,
        /* ''' */
        0x0000, 0x0000, 0x0000, 0x0070,
        0x00E0, 0x00C0, 0x0180, 0x0100,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'a' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x03E0, 0x07F0, 0x0E18, 0x0E00,
        0x0FC0, 0x0FF0, 0x0E78, 0x0E38,
        0x0F38, 0x0FF8, 0x1CF0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'b' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0038, 0x0038, 0x0038, 0x0038,
        0x07B8, 0x0FF8, 0x0E78, 0x1C38,
        0x1C38, 0x1C38, 0x1C38, 0x1C38,
        0x0E78, 0x0FF8, 0x07B8, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'c' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x03C0, 0x07F0, 0x0E70, 0x0438,
        0x0038, 0x0038, 0x0038, 0x0438,
        0x0E70, 0x07F0, 0x03C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'd' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x1C00, 0x1C00, 0x1C00, 0x1C00,
        0x1DE0, 0x1FF0, 0x1E70, 0x1C38,
        0x1C38, 0x1C38, 0x1C38, 0x1C38,
        0x1E70, 0x1FF0, 0x1DE0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'e' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x03E0, 0x07F0, 0x0E38, 0x0E38,
        0x0FF8, 0x0FF8, 0x0038, 0x0038,
        0x0E78, 0x07F0, 0x03E0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'f' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0F80, 0x0FC0, 0x01C0, 0x01C0,
        0x07F0, 0x07F0, 0x01C0, 0x01C0,
        0x01C0, 0x01C0, 0x01C0, 0x01C0,
        0x01C0, 0x01C0, 0x01C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'g' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x1DE0, 0x1FF0, 0x1E70, 0x1C38,
        0x1C38, 0x1C38, 0x1C38, 0x1C38,
        0x1E70, 0x1FF0, 0x1DE0, 0x1C00,
        0x1C38, 0x0FF8, 0x07E0, 0x0000,
        /* 'h' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0038, 0x0038, 0x0038, 0x0038,
        0x07B8, 0x0FF8, 0x1C78, 0x1C38,
        0x1C38, 0x1C38, 0x1C38, 0x1C38,
        0x1C38, 0x1C38, 0x1C38, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'i' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x01C0, 0x01C0, 0x0000, 0x0000,
        0x01C0, 0x01C0, 0x01C0, 0x01C0,
        0x01C0, 0x01C0, 0x01C0, 0x01C0,
        0x01C0, 0x01C0, 0x01C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'j' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0380, 0x0380, 0x0000, 0x0000,
        0x0380, 0x0380, 0x0380, 0x0380,
        0x0380, 0x0380, 0x0380, 0x0380,
        0x0380, 0x0380, 0x0380, 0x0380,
        0x03B0, 0x03F0, 0x01E0, 0x0000,
        /* 'k' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0070, 0x0070, 0x0070, 0x0070,
        0x1C70, 0x0E70, 0x0770, 0x03F0,
        0x03F0, 0x07F0, 0x0770, 0x0E70,
        0x0E70, 0x1C70, 0x1C70, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'l' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x01C0, 0x01C0, 0x01C0, 0x01C0,
        0x01C0, 0x01C0, 0x01C0, 0x01C0,
        0x01C0, 0x01C0, 0x01C0, 0x01C0,
        0x01C0, 0x01C0, 0x01C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'm' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x38EE, 0x7FFE, 0xE79E, 0xE38E,
        0xE38E, 0xE38E, 0xE38E, 0xE38E,
        0xE38E, 0xE38E, 0xE38E, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'n' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x07B8, 0x0FF8, 0x1E78, 0x1C38,
        0x1C38, 0x1C38, 0x1C38, 0x1C38,
        0x1C38, 0x1C38, 0x1C38, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'o' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x03C0, 0x0FF0, 0x0E70, 0x1C38,
        0x1C38, 0x1C38, 0x1C38, 0x1C38,
        0x0E70, 0x0FF0, 0x03C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'p' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x07B8, 0x0FF8, 0x0E78, 0x1C38,
        0x1C38, 0x1C38, 0x1C38, 0x1C38,
        0x0E78, 0x0FF8, 0x07B8, 0x0038,
        0x0038, 0x0038, 0x0038, 0x0000,
        /* 'q' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x1DE0, 0x1FF0, 0x1E70, 0x1C38,
        0x1C38, 0x1C38, 0x1C38, 0x1C38,
        0x1E70, 0x1FF0, 0x1DE0, 0x1C00,
        0x1C00, 0x1C00, 0x1C00, 0x0000,
        /* 'r' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0F7C, 0x07F8, 0x00F0, 0x0070,
        0x0070, 0x0070, 0x0070, 0x0070,
        0x0070, 0x0070, 0x0070, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 's' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x03E0, 0x07F0, 0x0E38, 0x0038,
        0x01F8, 0x07F0, 0x0F80, 0x0E00,
        0x0E38, 0x07F0, 0x03E0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 't' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0180, 0x01C0, 0x01C0, 0x01C0,
        0x1FFC, 0x1FFC, 0x01C0, 0x01C0,
        0x01C0, 0x01C0, 0x01C0, 0x01C0,
        0x11C0, 0x1FC0, 0x0F80, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'u' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x1C38, 0x1C38, 0x1C38, 0x1C38,
        0x1C38, 0x1C38, 0x1C38, 0x1C38,
        0x1E78, 0x1FF0, 0x1DE0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'v' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0E38, 0x0E38, 0x0E38, 0x0630,
        0x0770, 0x0770, 0x0360, 0x03E0,
        0x03E0, 0x01C0, 0x01C0, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'w' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0xE38F, 0x638E, 0x638C, 0x77DC,
        0x76DC, 0x36D8, 0x36D8, 0x3EF8,
        0x3C78, 0x1C70, 0x1C70, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'x' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x1C70, 0x1C70, 0x0EE0, 0x07C0,
        0x07C0, 0x0380, 0x07C0, 0x07C0,
        0x0EE0, 0x1C70, 0x1C70, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* 'y' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x1C1C, 0x1C1C, 0x0E38, 0x0E38,
        0x0E38, 0x0770, 0x0770, 0x0360,
        0x03E0, 0x03E0, 0x01C0, 0x01C0,
        0x00E0, 0x00F8, 0x0078, 0x0000,
        /* 'z' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x1FF8, 0x1FF8, 0x0E00, 0x0700,
        0x0380, 0x03C0, 0x01C0, 0x00E0,
        0x0070, 0x1FF8, 0x1FF8, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        /* '{' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0700, 0x0780, 0x07C0, 0x01C0,
        0x01C0, 0x01C0, 0x01C0, 0x01C0,
        0x01E0, 0x00F0, 0x00F0, 0x01E0,
        0x01C0, 0x01C0, 0x01C0, 0x01C0,
        0x07C0, 0x07C0, 0x0780, 0x0000,
        /* '|' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0180, 0x0180, 0x0180, 0x0180,
        0x0180, 0x0180, 0x0180, 0x0180,
        0x0180, 0x0180, 0x0180, 0x0180,
        0x0180, 0x0180, 0x0180, 0x0180,
        0x0180, 0x0180, 0x0180, 0x0000,
        /* '}' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x00E0, 0x01E0, 0x03E0, 0x0380,
        0x0380, 0x0380, 0x0380, 0x0380,
        0x0780, 0x0F00, 0x0F00, 0x0780,
        0x0380, 0x0380, 0x0380, 0x0380,
        0x03E0, 0x03E0, 0x01E0, 0x0000,
        /* '~' */
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x70F8, 0x3FFC,
        0x1FFE, 0x0F86, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
        0x0000, 0x0000, 0x0000, 0x0000,
      };

