/*********************************************************************************************************//**
 * @file    GPIO/InputOutput/main.c
 * @version V1.0
 * @date    04/11/2011
 * @brief   Main program.
 *************************************************************************************************************
 *
 * <h2><center>Copyright (C) 2011 Holtek Semiconductor Inc. All rights reserved</center></h2>
 *
 ************************************************************************************************************/

/* Includes ------------------------------------------------------------------------------------------------*/
#include "ht32f125x.h"
#include "ht32f125x_board.h"
#include "LCD.h"
#include "Protocol.h"
#include "Hardware.h"
#include "main.h"



extern SB_OEM_PKT* Command_Packet;
extern  vu32 gwSysTickCnt;
char cFlagA, cFlagB, cFlagC,gJump;

int main(void)
{
	u32 i = 0;
  char Button_State = FAIL;
	int ID_Count = 0;
	int rtn;
	int iTimeCount = 0;
	char cLoginCount = 0;
	char j =0xaa;
	cFlagA = 0;
	cFlagB = 0;
	cFlagC = 0;
	gJump = 0;
#if (HT32F_LIB_DEBUG == 1)
  debug();
#endif
	NVIC_Configuration();               /* NVIC configuration                                                 */
	CKCU_Configuration();               /* System Related configuration                                       */
	//  while(1);
	
	GPIO_Configuration();               /* GPIO Related configure                                             */
	USART_Configuration();              /* USART Related configure     										  */
	Display_init();
	//delay_ms(DELAY_TIME);
	i = Initialization(9600);	
	if(i != OK)
		while(1)
			;
	Display_Main();
	while(1)
	{
		iTimeCount = 0;
		Button_State = FAIL;
		while(Button_State == FAIL)
			Button_State = Button_Detect();
		switch(Button_State)
		{
			case ENROLL_CLICK:
				GPIO_ClearOutBits(GPIOB,LED_ENROLL);
				LED(1);
				for(ID_Count = 0; ID_Count < FP_MAX_USERS; ID_Count++)
				{
					rtn = CheckEnroll(ID_Count);
					if(rtn == NACK_IS_NOT_USED)
						break;
				}						
				rtn = Enroll_Start(ID_Count);
				if(rtn < 0)
				{
					Display_Error();
					Button_State = FAIL;
					while(Button_State != DEL_CLICK)
						Button_State = Button_Detect();
					Display_Main();
					LED(0);
					GPIO_SetOutBits(GPIOB,LED_ENROLL);
					break;
				}
				else if(rtn >= NACK_NONE)
				{
					Display_Error_Code(rtn);
					Button_State = FAIL;
					while(Button_State != DEL_CLICK)
						Button_State = Button_Detect();
					Display_Main();
					LED(0);
					GPIO_SetOutBits(GPIOB,LED_ENROLL);
					break;
				}
				
				for(j = 1; j < 4; j++)
				{
					Display_Press();
//					_t0on = 1;
//					_t0f = 0;
					SYSTICK_CounterCmd(SYSTICK_COUNTER_ENABLE);
					gwSysTickCnt = 0;
					iTimeCount = 0;
					while(iTimeCount < TimeOut)
					{
						rtn = CaptureFinger(1);
						/*if(rtn == OK)
						{
							delay_ms(10);
							rtn = CaptureFinger(1);
						}  */
						if(rtn == OK)
							break;
//						if(_t0f)
						if(gwSysTickCnt >= DELAY_TIME)
						{
//							_tmr0h = 0x85;
//							_tmr0l = 0xED;
//							_t0f = 0;
							gwSysTickCnt = 0;
							iTimeCount++;
						}
						Button_State = Button_Detect();
						if(Button_State == DEL_CLICK)
							break;
					}
					/* Disable SysTick Counter                                                                                */
					SYSTICK_CounterCmd(SYSTICK_COUNTER_DISABLE);
					/* Clear SysTick Counter                                                                                  */
					SYSTICK_CounterCmd(SYSTICK_COUNTER_CLEAR);
					if(Button_State == DEL_CLICK)
					{
						break;
					}
//					_t0on = 0;
					if(iTimeCount >= TimeOut)
					{
						iTimeCount = 0;
						rtn = NACK_TIMEOUT;
						break;
					}
					rtn = Enroll_nth(j);
					if(rtn < 0)
					{
						Display_Error();
						break;
					}
					else if(rtn >= NACK_NONE)
					{
						Display_Error_Code(rtn);
						break;
					}
					else if(rtn < FP_MAX_USERS)
					{
						Display_Used(rtn);
						break;
					}
					Display_Remove();
					if(j < 3)
					{
						while(1)
						{
							rtn = RemoveFinger();
							if(rtn < 0)
							{
								Display_Error();
								break;
							}
							else if(rtn >= NACK_NONE)
							{
								Display_Error_Code(rtn);
								break;
							}
							if(rtn != 0)
								break;
						}
						if(rtn >= NACK_NONE || rtn < 0)
							break;
					}
				}
				if(Button_State == DEL_CLICK)
				{
					Display_Main();
					LED(0);
					GPIO_SetOutBits(GPIOB,LED_ENROLL);
					break;
				}
				if(rtn >= NACK_NONE || rtn < 0)
				{
					Display_Error_Code(rtn);
					Button_State = FAIL;
					while(Button_State != DEL_CLICK)
						Button_State = Button_Detect();
					Display_Main();
					LED(0);
					GPIO_SetOutBits(GPIOB,LED_ENROLL);
				}
				else if(rtn < FP_MAX_USERS)
				{
					Button_State = FAIL;
					while(Button_State != DEL_CLICK)
						Button_State = Button_Detect();
					Display_Main();
					LED(0);
					GPIO_SetOutBits(GPIOB,LED_ENROLL);
				}
				else
				{
					Display_Enroll(3,ID_Count);
					Button_State = FAIL;
					while(Button_State != DEL_CLICK)
						Button_State = Button_Detect();
					Display_Main();
					LED(0);
					GPIO_SetOutBits(GPIOB,LED_ENROLL);
				}
				break;
			case LOGIN_CLICK:
				LED(1);
				GPIO_ClearOutBits(GPIOB,LED_LOGIN);
				rtn = GetEnrollCount();
				if(rtn == 0)
				{
					Display_Login(0,0);
					Button_State = FAIL;
					while(Button_State != DEL_CLICK)
						Button_State = Button_Detect();
					Display_Main();
					LED(0);
					GPIO_SetOutBits(GPIOB,LED_LOGIN);
					break;
				}
				else if(rtn < 0)
				{
					Display_Error();
					Button_State = FAIL;
					while(Button_State != DEL_CLICK)
						Button_State = Button_Detect();
					Display_Main();
					LED(0);
					GPIO_SetOutBits(GPIOB,LED_LOGIN);
					break;
				}							
				for(cLoginCount = 0; cLoginCount < LOGIN_NUMBER; cLoginCount++)
				{
					Display_Press();
//					_t0on = 1;
//					_t0f = 0;
					SYSTICK_CounterCmd(SYSTICK_COUNTER_ENABLE);
					gwSysTickCnt = 0;
					iTimeCount = 0;
					while(iTimeCount < TimeOut)
					{
						rtn = CaptureFinger(0);
						/*if(rtn == OK)
						{
							delay_ms(10);
							rtn = CaptureFinger(0);
						}  */
						Button_State = Button_Detect();
						if(Button_State == DEL_CLICK)
						{
							//Display_Main();
							rtn = NACK_TIMEOUT;
							break;
						}
						if(rtn == OK)
							break;
//						if(_t0f)
						if(gwSysTickCnt >= DELAY_TIME)
						{
//							_tmr0h = 0x85;
//							_tmr0l = 0xED;
//							_t0f = 0;
							gwSysTickCnt = 0;
							iTimeCount++;
						}
					}
					/* Disable SysTick Counter                                                                                */
					SYSTICK_CounterCmd(SYSTICK_COUNTER_DISABLE);
					/* Clear SysTick Counter                                                                                  */
					SYSTICK_CounterCmd(SYSTICK_COUNTER_CLEAR);
//					_t0on = 0;
					if(iTimeCount >= TimeOut)
					{
						iTimeCount = 0;
						rtn == NACK_TIMEOUT;
						break;
					}
					else if(rtn != OK)
					{
						Display_Main();
						LED(0);
						GPIO_SetOutBits(GPIOB,LED_LOGIN);
						break;
					}
					//Display_Remove();
					rtn = Identify();
					if(rtn < FP_MAX_USERS)
						break;
				}
				if(rtn == NACK_TIMEOUT)
					break;
				if(rtn < 0)
				{
					Display_Error();
				}
				else if(rtn == NACK_IDENTIFY_FAILED)
				{
					Display_Login(2,0);
//					_pa6 = 0;
					GPIO_ClearOutBits(GPIOB,LED_FAIL);
				}
				else if(rtn >= NACK_NONE)
				{
					Display_Error_Code(rtn);
				}
				else				   
				{
					Display_Login(1,rtn);
//					_pa5 = 0;
					GPIO_ClearOutBits(GPIOB,LED_PASS);
					GPIO_SetOutBits(GPIOB,COIL_CONTROL);
				}
				Button_State = FAIL;
				while(Button_State != DEL_CLICK)
					Button_State = Button_Detect();
				Display_Main();
				LED(0);
				GPIO_SetOutBits(GPIOB,LED_LOGIN);
				GPIO_SetOutBits(GPIOB,LED_FAIL);
				GPIO_SetOutBits(GPIOB,LED_PASS);
				GPIO_ClearOutBits(GPIOB,COIL_CONTROL);
				break;
			case DEL_CLICK:
				GPIO_ClearOutBits(GPIOB,LED_DEL);			
				Display_Delete(2,ID_Count);
				Button_State = FAIL;
				while(Button_State != ENROLL_CLICK && Button_State != DEL_CLICK)
					Button_State = Button_Detect();
				if(Button_State == ENROLL_CLICK)
				{
					rtn = DeleteAll();
					if(rtn < 0)
					{
						Display_Error();
						Button_State = FAIL;
						while(Button_State != DEL_CLICK)
							Button_State = Button_Detect();
						Display_Main();
						GPIO_SetOutBits(GPIOB,LED_DEL);
						break;
					}
					if(rtn != OK)
					{
						Display_Error_Code(rtn);
						Button_State = FAIL;
						while(Button_State != DEL_CLICK)
							Button_State = Button_Detect();
						Display_Main();
						GPIO_SetOutBits(GPIOB,LED_DEL);
						break;
					}
					else
					{
						Display_Delete(4,ID_Count);
						Button_State = FAIL;
						while(Button_State != DEL_CLICK)
							Button_State = Button_Detect();
						Display_Main();
						GPIO_SetOutBits(GPIOB,LED_DEL);
					}
				}
				else if(Button_State == DEL_CLICK)
				{
					Display_Main();
					GPIO_SetOutBits(GPIOB,LED_DEL);
				}
				break;
			default:
				Display_Main();
				break;
		}
	}
}

char Button_Detect()
{
	if(cFlagA == 0)
	{
		if(Erase_Detect())
		{
			cFlagA = 1;
			gJump = 0;
			return ENROLL_CLICK;
		}
	}
	else if(!Erase_Detect())
	{
		cFlagA = 0;
	}
	if(cFlagB == 0)
	{
		if(!Login_Detect())
		{
			cFlagB = 1;
			gJump = 0;
			return LOGIN_CLICK;
		}
	}
	else if(Login_Detect())
	{
		cFlagB = 0;
	}
	if(cFlagC == 0)
	{
		if(!Del_Detect())
		{
			cFlagC = 1;
			gJump = 0;
			return DEL_CLICK;
		}
	}
	else if(Del_Detect())
	{
		cFlagC = 0;
	}
	return FAIL;
}
