/*********************************************************************************************************//**
 * @file    GPIO/InputOutput/ht32f125x_conf.h
 * @version V1.0
 * @date    04/11/2011
 * @brief   Library configuration file.
 *************************************************************************************************************
 *
 * <h2><center>Copyright (C) 2011 Holtek Semiconductor Inc. All rights reserved</center></h2>
 *
 ************************************************************************************************************/

/*
//-------- <<< Use Configuration Wizard in Context Menu >>> -----------------
*/
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef __HT32F125x_CONF_H
#define __HT32F125x_CONF_H

/* Includes ------------------------------------------------------------------------------------------------*/
/* Exported types ------------------------------------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------------------------------------*/

/* The DEBUG definition to enter debug mode for library                                                     */
/*
//<e> Library Debug mode
//</e>
*/
#define HT32F_LIB_DEBUG     0


#define RETARGET_USART      1
#define RETARGET_ITM        2

/* RETARGET definition to use USART function by C Library                                                   */
/*
//  <e0> Enable Retarget
//  <o1> Retarget port
//      <1=> USART
//      <2=> ITM
//  </e>
*/
#define _RETARGET            1
#define RETARGET_PORT        1
#if (RETARGET_PORT == RETARGET_USART)
    #define RETARGET_USART_PORT      USART
    #define RETARGET_COM_PORT        COM1
#endif

/*
//<e> Enable CKOUT function
//</e>
*/
#define ENABLE_CKOUT              0



/* Enable/disable the specific peripheral inclusion                                                         */

/* USART ---------------------------------------------------------------------------------------------------*/
/*
//<e0> USART Library
//</e>
*/
#define _USART        1

/* SPI -----------------------------------------------------------------------------------------------------*/
/*
//<e0> SPI Library
//</e>
*/
#define _SPI          1

/* ADC -----------------------------------------------------------------------------------------------------*/
/*
//<e0> ADC Library
//</e>
*/
#define _ADC          1

/* Comparator/OPA ------------------------------------------------------------------------------------------*/
/*
//<e0> Comparator Library
//  <q1> CMP_OP0
//  <q2> CMP_OP1
//</e>
*/
#define _CMP_OP         1
#if _CMP_OP
#define _CMP_OP0        1
#define _CMP_OP1        1
#endif

/* GPIO ----------------------------------------------------------------------------------------------------*/
/*
//<e0> GPIO Library
//  <q1> AFIO
//  <q2> GPIO Port A
//  <q3> GPIO Port B
//</e>
*/
#define _GPIO         1
#if _GPIO
#define _AFIO         1
#define _GPIOA        1
#define _GPIOB        1
#endif

/* EXTI ----------------------------------------------------------------------------------------------------*/
/*
//<e0> EXTI Library
//</e>
*/
#define _EXTI         1

/* I2C -----------------------------------------------------------------------------------------------------*/
/*
//<e0> I2C Library
//</e>
*/
#define _I2C          1

/* WDT -----------------------------------------------------------------------------------------------------*/
/*
//<e0> WDT Library
//</e>
*/
#define _WDT          1

/* RTC -----------------------------------------------------------------------------------------------------*/
/*
//<e0> RTC Library
//</e>
*/
#define _RTC          1

/* PWRCU ---------------------------------------------------------------------------------------------------*/
/*
//<e0> PWRCU Library
//</e>
*/
#define _PWRCU        1

/* GPTM ----------------------------------------------------------------------------------------------------*/
/*
//<e0> GPTM Library
//  <q1> GPTM0
//  <q2> GPTM1
//</e>
*/
#define _GPTM         1
#if _GPTM
#define _GPTM0        1
#define _GPTM1        1
#endif

/* Flash control -------------------------------------------------------------------------------------------*/
/*
//<e0> Flash Control Library
//</e>
*/
#define _FLASH        1

/* Clock Control -------------------------------------------------------------------------------------------*/
/*
//<e0> Clock Control Library
//</e>
*/
#define _CKCU         1

/* RSTCU ---------------------------------------------------------------------------------------------------*/
/*
//<e0> RSTCU Library
//</e>
*/
#define _RSTCU        1

/* Misc ----------------------------------------------------------------------------------------------------*/
/*
//<e0> Misc Library
//</e>
*/
#define _MISC         1


/* Exported macro ------------------------------------------------------------------------------------------*/
/* Exported functions --------------------------------------------------------------------------------------*/

#endif /* __HT32F125x_CONF_H -------------------------------------------------------------------------------*/
