#include "LCD.h"
#include "ht32f125x.h"
#include "Protocol.h"


#define LCD_RS	GPIO_PIN_7
#define LCD_RW	GPIO_PIN_6
#define LCD_E	GPIO_PIN_5


void Display_Delay()
{
	unsigned char i;
	for(i = 0; i < 100; i++)
		;
}

void Display_init()
{
	unsigned char First[16] = {'I','n','i','t','i','a','l','i','z','e','.','.','.',0x20,0x20,0x20};
	unsigned char Second[16] = {0x20,0x20,0x20,0x20,0x20,0x20,0x20,'G','i','n','g','y','t','e','c','h'};
	GPIO_SetOutBits(GPIOB, LCD_E);
	GPIO_ClearOutBits(GPIOB, LCD_RS);
	GPIO_ClearOutBits(GPIOB, LCD_RW);
	GPIO_WriteOutData(GPIOA, FUNCTION_SET);
	delay_ms(1);
	GPIO_ClearOutBits(GPIOB, LCD_E);
	delay_ms(1);
	Display_Off();
	Display_On();
	GPIO_SetOutBits(GPIOB, LCD_E);
	GPIO_WriteOutData(GPIOA, ENTRY_MODE_SET);
	delay_ms(1);
	GPIO_ClearOutBits(GPIOB, LCD_E);
	delay_ms(1);
	Display_Clear();
	Display_Write(First,sizeof(First),0);
	Display_Write(Second,sizeof(Second),1);	
}
void Display_Off()
{
	GPIO_SetOutBits(GPIOB, LCD_E);
	GPIO_ClearOutBits(GPIOB, LCD_RS);
	GPIO_ClearOutBits(GPIOB, LCD_RW);
	GPIO_WriteOutData(GPIOA, DISPLAY_OFF);
	delay_ms(1);
	GPIO_ClearOutBits(GPIOB, LCD_E);
	delay_ms(1);
}
void Display_On()
{
	GPIO_SetOutBits(GPIOB, LCD_E);
	GPIO_ClearOutBits(GPIOB, LCD_RS);
	GPIO_ClearOutBits(GPIOB, LCD_RW);
	GPIO_WriteOutData(GPIOA, DISPLAY_ON);
	delay_ms(1);
	GPIO_ClearOutBits(GPIOB, LCD_E);
	delay_ms(1);
}

void Display_Clear()
{
	GPIO_SetOutBits(GPIOB, LCD_E);
	GPIO_ClearOutBits(GPIOB, LCD_RS);
	GPIO_ClearOutBits(GPIOB, LCD_RW);
	GPIO_WriteOutData(GPIOA, CLEAR_DISPLAY);
	delay_ms(1);
	GPIO_ClearOutBits(GPIOB, LCD_E);
	delay_ms(1);
}
void Display_Second_Line()
{
	GPIO_ClearOutBits(GPIOB, LCD_RS);
	GPIO_ClearOutBits(GPIOB, LCD_RW);
	GPIO_SetOutBits(GPIOB, LCD_E);
	GPIO_WriteOutData(GPIOA, SET_DD_RAM);
	delay_ms(1);
	GPIO_ClearOutBits(GPIOB, LCD_E);
	delay_ms(1);
}
void Display_Return_Home()
{
	GPIO_ClearOutBits(GPIOB, LCD_RS);
	GPIO_ClearOutBits(GPIOB, LCD_RW);
	GPIO_SetOutBits(GPIOB, LCD_E);
	GPIO_WriteOutData(GPIOA, RETURN_HOME);
	delay_ms(1);
	GPIO_ClearOutBits(GPIOB, LCD_E);
	delay_ms(1);
}
void Display_Put_Data(unsigned char *ucData)
{
	GPIO_SetOutBits(GPIOB, LCD_RS);
	GPIO_ClearOutBits(GPIOB, LCD_RW);
	GPIO_SetOutBits(GPIOB, LCD_E);
	GPIO_WriteOutData(GPIOA, *ucData);
	Display_Delay();
	GPIO_ClearOutBits(GPIOB, LCD_E);
	Display_Delay();
}
void Display_Write(unsigned char * pBuf,unsigned char ucLen,char cFlag)
{
	unsigned char tmp;
	//Display_Off();
	if(cFlag == 0)
	{
		Display_Return_Home();
		for(tmp = 0; tmp < ucLen; tmp++)
			Display_Put_Data(pBuf + tmp);
	}
	else
	{
		Display_Second_Line();
		for(tmp = 0; tmp < ucLen; tmp++)
			Display_Put_Data(pBuf + tmp);
	}
	//Display_On();
}
void Display_Main()
{
	unsigned char First[16] = {'G','i','n','g','y',0x20,0x20,0x20,0x20,'V','e','r',':','3','.','0'};
	unsigned char Sencod[16] = {'E','n','r','o','l','l',0x20,'L','o','g','i','n',0x20,'D','e','l',};
	Display_Write(First,sizeof(First),0);
	Display_Write(Sencod,sizeof(Sencod),1);	
}
void Display_Enroll(char cFlag,int cCount)
{
	unsigned char First[16] = {'E','n','r','o','l','l',0x20,0x20,0x20,'I','D','=','_','_','_','_'};
	unsigned char Sencod[16] = {0x20,0x20,'+',0x20,0x20,0x20,0x20,0x20,'-',0x20,0x20,0x20,'E','X','I','T',};
	if(cFlag == 1)
	{
    First[12] = (cCount / 1000) + 0x30;
    First[13] = ((cCount % 1000) / 100) + 0x30;
		First[14] = ((cCount % 100) / 10) + 0x30;
		First[15] = cCount % 10 + 0x30;
		Sencod[8] = 'O';
		Sencod[9] = 'K';
	}
	else if(cFlag == 2)
	{
		First[12] = (cCount / 1000) + 0x30;
    First[13] = ((cCount % 1000) / 100) + 0x30;
		First[14] = ((cCount % 100) / 10) + 0x30;
		First[15] = cCount % 10 + 0x30;
		Sencod[2] = 'O';
		Sencod[3] = 'K';
	}
	else if(cFlag == 3)
	{
		First[12] = (cCount / 1000) + 0x30;
    First[13] = ((cCount % 1000) / 100) + 0x30;
		First[14] = ((cCount % 100) / 10) + 0x30;
		First[15] = cCount % 10 + 0x30;
		Sencod[0] = 'S';
		Sencod[1] = 'u';
		Sencod[2] = 'c';
		Sencod[3] = 'c';
		Sencod[4] = 'e';
		Sencod[5] = 's';
		Sencod[6] = 's';
		Sencod[7] = 0x20;
		Sencod[8] = 0x20;
		Sencod[9] = 0x20;
		Sencod[10] = 0x20;
		Sencod[11] = 0x20;
		Sencod[12] = 'E';
		Sencod[13] = 'X';
		Sencod[14] = 'I';
		Sencod[15] = 'T';
	}
	Display_Write(First,sizeof(First),0);
	Display_Write(Sencod,sizeof(Sencod),1);	
}
void Display_Delete(char cFlag,char cCount)
{
	unsigned char First[16] = {'D','e','l','e','t','e',0x20,0x20,0x20,'I','D','=','_','_','_','_'};
	unsigned char Sencod[16] = {0x20,0x20,'+',0x20,0x20,0x20,0x20,'A','l','l',0x20,0x20,'E','X','I','T'};
	if(cFlag == 1)
	{
		First[12] = (cCount / 1000) + 0x30;
    First[13] = ((cCount % 1000) / 100) + 0x30;
		First[14] = ((cCount % 100) / 10) + 0x30;
		First[15] = cCount % 10 + 0x30;
		Sencod[7] = 0x20;
		Sencod[8] = 'O';
		Sencod[9] = 'K';
	}
	else if(cFlag == 2)
	{
		First[7] = 'A';
		First[8] = 'l';
		First[9] = 'l';
    First[10] = 0x20;
		First[11] = 0x20;
		First[12] = 0x20;
		First[13] = 0x20;
		First[14] = 0x20;
		First[15] = 0x20;
		Sencod[2] = 'O';
		Sencod[3] = 'K';
		Sencod[7] = 0x20;
		Sencod[8] = 0x20;
		Sencod[9] = 0x20;
	}
	else if(cFlag == 3)
	{
		First[12] = (cCount / 1000) + 0x30;
    First[13] = ((cCount % 1000) / 100) + 0x30;
		First[14] = ((cCount % 100) / 10) + 0x30;
		First[15] = cCount % 10 + 0x30;
		Sencod[0] = 'S';
		Sencod[1] = 'u';
		Sencod[2] = 'c';
		Sencod[3] = 'c';
		Sencod[4] = 'e';
		Sencod[5] = 's';
		Sencod[6] = 's';
		Sencod[7] = 0x20;
		Sencod[8] = 0x20;
		Sencod[9] = 0x20;
		Sencod[10] = 0x20;
		Sencod[11] = 0x20;
		Sencod[12] = 'E';
		Sencod[13] = 'X';
		Sencod[14] = 'I';
		Sencod[15] = 'I';
	}
	else if(cFlag == 4)
	{
		First[7] = 'A';
		First[8] = 'l';
		First[9] = 'l';
    First[10] = 0x20;
		First[11] = 0x20;
		First[12] = 0x20;
		First[13] = 0x20;
		First[14] = 0x20;
		First[15] = 0x20;
		Sencod[0] = 'S';
		Sencod[1] = 'u';
		Sencod[2] = 'c';
		Sencod[3] = 'c';
		Sencod[4] = 'e';
		Sencod[5] = 's';
		Sencod[6] = 's';
		Sencod[7] = 0x20;
		Sencod[8] = 0x20;
		Sencod[9] = 0x20;
		Sencod[10] = 0x20;
		Sencod[11] = 0x20;
		Sencod[12] = 'E';
		Sencod[13] = 'X';
		Sencod[14] = 'I';
		Sencod[15] = 'T';
	}
	Display_Write(First,sizeof(First),0);
	Display_Write(Sencod,sizeof(Sencod),1);	
}
void Display_Press()
{
	unsigned char First[16] = {'P','r','e','s','s',0x20,'f','i','n','g','e','r',0x20,0x20,0x20,0x20};
	unsigned char Sencod[16] = {0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,'E','X','I','T'};
	Display_Write(First,sizeof(First),0);
	Display_Write(Sencod,sizeof(Sencod),1);	
}
void Display_Remove()
{
	unsigned char First[16] = {'R','e','m','o','v','e',0x20,'f','i','n','g','e','r',0x20,0x20,0x20};
	unsigned char Sencod[16] = {0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20};
	Display_Write(First,sizeof(First),0);
	Display_Write(Sencod,sizeof(Sencod),1);	
}
void Display_Error_Code(unsigned long ulCode)
{
	unsigned char ucTmp1,ucTmp2;
	char* pError;
	unsigned char First[16] = {'E','r','r','o','r',0x20,'C','o','d','e',0x20,0x20,0x20,0x20,0x20,0x20};
	unsigned char Sencod[16] = {0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,'E','X','I','T'};
	ucTmp1 = ulCode / 256;
	ucTmp2 = ulCode % 256;
	First[11] = ucTmp1 / 16 + 0x30;
	First[12] = ucTmp1 % 16 + 0x30;
	First[13] = ucTmp2 / 16+ 0x30;
	if(ucTmp2 % 16 <= 9)
		First[14] = ucTmp2 % 16 + 0x30;
	else
		First[14] = ucTmp2 % 16 + 0x37;
	if(ulCode == NACK_IS_ALREADY_USED)
	{
		Sencod[0] = 'n';
		Sencod[1] = 'o';
		Sencod[2] = 't';
		Sencod[3] = 0x20;
		Sencod[4] = 'e';
		Sencod[5] = 'm';
		Sencod[6] = 'p';
		Sencod[7] = 't';
		Sencod[8] = 'y';
	}
	else if(ulCode == NACK_COMM_ERR)
	{
		strcpy(Sencod,"Commun Error");
	}
	else if(ulCode == NACK_DB_IS_FULL)
	{
		Sencod[0] = 'I';
		Sencod[1] = 'D';
		Sencod[2] = 0x20;
		Sencod[3] = 'i';
		Sencod[4] = 's';
		Sencod[5] = 0x20;
		Sencod[6] = 'f';
		Sencod[7] = 'u';
		Sencod[8] = 'l';
		Sencod[9] = 'l';
	}
	else if(ulCode == NACK_DB_IS_EMPTY)
	{
		Sencod[0] = 'I';
		Sencod[1] = 'D';
		Sencod[2] = 0x20;
		Sencod[3] = 'i';
		Sencod[4] = 's';
		Sencod[5] = 0x20;
		Sencod[6] = 'e';
		Sencod[7] = 'm';
		Sencod[8] = 'p';
		Sencod[9] = 't';
		Sencod[10] = 'y';	
	}
	Display_Write(First,sizeof(First),0);
	Display_Write(Sencod,sizeof(Sencod),1);	
}
void Display_Error()
{
	unsigned char First[16] = {'C','o','m','m','u','n','i','c','a','t','i','o','n',0x20,0x20,0x20};
	unsigned char Sencod[16] = {'E','r','r','o','r',0x20,0x20,0x20,0x20,0x20,0x20,0x20,'E','X','I','T'};
	Display_Write(First,sizeof(First),0);
	Display_Write(Sencod,sizeof(Sencod),1);	
}
void Display_Login(char cFlag,int ID)
{
	unsigned char First[16] = {'L','o','g','i','n',0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20};
	unsigned char Sencod[16] = {0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,'E','X','I','T'};
	if(cFlag == 0)
	{
		Sencod[0] = 'N';
		Sencod[1] = 'o';
		Sencod[2] = 0x20;
		Sencod[3] = 'u';
		Sencod[4] = 's';
		Sencod[5] = 'e';
		Sencod[6] = 'r';
		Sencod[7] = '!';
	}
	else if(cFlag == 1)
	{
		Sencod[0] = 'I';
		Sencod[1] = 'D';
		Sencod[2] = '=';
    Sencod[3] = (ID / 1000) + 0x30;
    Sencod[4] = ((ID % 1000) / 100) + 0x30;
		Sencod[5] = ((ID % 100) / 10) + 0x30;
		Sencod[6] = ID % 10 + 0x30;
	}
	else
	{
		Sencod[0] = 'F';
		Sencod[1] = 'a';
		Sencod[2] = 'i';
		Sencod[3] = 'l';
	}
	Display_Write(First,sizeof(First),0);
	Display_Write(Sencod,sizeof(Sencod),1);
}
void Display_Used(int cCount)
{
	unsigned char First[16] = {'E','n','r','o','l','l',0x20,0x20,0x20,'I','D','=','_','_','_','_'};
	unsigned char Sencod[16] = {0x20,0x20,'+',0x20,0x20,0x20,0x20,0x20,'-',0x20,0x20,0x20,'E','X','I','T',};
	
	First[12] = (cCount / 1000) + 0x30;
  First[13] = ((cCount % 1000) / 100) + 0x30;
  First[14] = ((cCount % 100) / 10) + 0x30;
	First[15] = cCount % 10 + 0x30;
	Sencod[0] = 'i';
	Sencod[1] = 's';
	Sencod[2] = 0x20;
	Sencod[3] = 'u';
	Sencod[4] = 's';
	Sencod[5] = 'e';
	Sencod[6] = 'd';
	Sencod[7] = 0x20;
	Sencod[8] = 0x20;
	Sencod[9] = 0x20;
	Sencod[10] = 0x20;
	Sencod[11] = 0x20;
	Sencod[12] = 'E';
	Sencod[13] = 'X';
	Sencod[14] = 'I';
	Sencod[15] = 'T';
	
	Display_Write(First,sizeof(First),0);
	Display_Write(Sencod,sizeof(Sencod),1);	
}