/*********************************************************************************************************//**
 * @file    ht32f125x_serial.c
 * @version V1.0
 * @date    04/11/2011
 * @brief   This file provides all the Low level serial routines for HT32F125x.
 *************************************************************************************************************
 *
 * <h2><center>Copyright (C) 2011 Holtek Semiconductor Inc. All rights reserved</center></h2>
 *
 ************************************************************************************************************/

/* Includes ------------------------------------------------------------------------------------------------*/
#include "ht32f125x.h"

#if (_RETARGET == 1)
#if (RETARGET_PORT == RETARGET_USART)

/* Private typedef -----------------------------------------------------------------------------------------*/
/* Private define ------------------------------------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------------------------------------*/
/* Private functions ---------------------------------------------------------------------------------------*/

/*********************************************************************************************************//**
 * @brief  Put char to USART.
 * @param  ch: The char put to USART.
 * @retval The char put to USART.
 ************************************************************************************************************/
u16 SERIAL_PutChar(u16 ch)
{
  USART_SendData(RETARGET_USART_PORT, (u8)ch);
  while (USART_GetLineStatus(RETARGET_USART_PORT, USART_LSR_TE) == RESET)
  {
  }
  return ch;
}

/*********************************************************************************************************//**
 * @brief  Get char from USART.
 * @retval The char got from USART.
 ************************************************************************************************************/
u16 SERIAL_GetChar(void)
{
  while (USART_GetLineStatus(RETARGET_USART_PORT, USART_LSR_RFDR) == RESET)
  {
  }
  return USART_ReceiveData(RETARGET_USART_PORT);
}
#endif
#endif
