/*********************************************************************************************************//**
 * @file    ht32f125x_lib.c
 * @version V1.0
 * @date    04/11/2011
 * @brief   Initialization of the library pointers for debug mode.
 *************************************************************************************************************
 *
 * <h2><center>Copyright (C) 2011 Holtek Semiconductor Inc. All rights reserved</center></h2>
 *
 ************************************************************************************************************/

#define EXT

/* Includes ------------------------------------------------------------------------------------------------*/
#include "ht32f125x.h"

/* Private functions ---------------------------------------------------------------------------------------*/

#if (HT32F_LIB_DEBUG == 1)
#warning "Library debug mode has been enabled."
#warning "Remember to disable after the debug operation has been finished."
/*********************************************************************************************************//**
 * @brief  Initialization of the library pointers for debug mode.
 * @retval None
 ************************************************************************************************************/
void debug(void)
{
#if _USART
  USART = (USART_TypeDef *) USART_BASE;
#endif

#if _SPI
  SPI = (SPI_TypeDef *) SPI_BASE;
#endif

#if _ADC
  ADC = (ADC_TypeDef *) ADC_BASE;
#endif

#if _CMP_OP0
  CMP_OP0 = (CMP_OP_TypeDef *) CMP_OP0_BASE;
#endif

#if _CMP_OP1
  CMP_OP1 = (CMP_OP_TypeDef *) CMP_OP1_BASE;
#endif

#if _AFIO
  AFIO = (AFIO_TypeDef *) AFIO_BASE;
#endif

#if _GPIOA
  GPIOA = (GPIO_TypeDef *) GPIOA_BASE;
#endif

#if _GPIOB
  GPIOB = (GPIO_TypeDef *) GPIOB_BASE;
#endif

#if _EXTI
  EXTI = (EXTI_TypeDef *) EXTI_BASE;
#endif

#if _I2C
  I2C = (I2C_TypeDef *) I2C_BASE;
#endif

#if _WDT
  WDT = (WDT_TypeDef *) WDT_BASE;
#endif

#if _RTC
  RTC = (RTC_TypeDef *) RTC_BASE;
#endif

#if _PWRCU
  PWRCU = (PWRCU_TypeDef *) PWRCU_BASE;
#endif

#if _GPTM0
  GPTM0 = (GPTM_TypeDef *) GPTM0_BASE;
#endif

#if _GPTM1
  GPTM1 = (GPTM_TypeDef *) GPTM1_BASE;
#endif

#if _FLASH
  FLASH = (FLASH_TypeDef *) FLASH_BASE;
#endif

#if _CKCU
  CKCU = (CKCU_TypeDef *) CKCU_BASE;
#endif

#if _RSTCU
  RSTCU = (RSTCU_TypeDef *) RSTCU_BASE;
#endif
}

#endif /* DEBUG --------------------------------------------------------------------------------------------*/
