/*********************************************************************************************************//**
 * @file    ht32f125x_lib.h
 * @version V1.0
 * @date    04/11/2011
 * @brief   The header file includes all the header files of the libraries.
 *************************************************************************************************************
 *
 * <h2><center>Copyright (C) 2011 Holtek Semiconductor Inc. All rights reserved</center></h2>
 *
 ************************************************************************************************************/
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef __HT32F125x_LIB_H
#define __HT32F125x_LIB_H

/* Includes ------------------------------------------------------------------------------------------------*/
#include "ht32f125x_conf.h"
#include <stdio.h>

/* Peripheral declaration                                                                                   */

#if (HT32F_LIB_DEBUG == 0)

/* Non Debug Mode                                                                                           */
/* Periperals defined in HT32f125x.h                                                                        */

#else

/* Debug Mode                                                                                               */
#undef USART
#undef SPI
#undef ADC
#undef CMP_OP0
#undef CMP_OP1
#undef GPIOA
#undef GPIOB
#undef AFIO
#undef EXTI
#undef I2C
#undef WDT
#undef RTC
#undef PWRCU
#undef GPTM0
#undef GPTM1
#undef FLASH
#undef CKCU
#undef RSTCU

#if _USART
  EXT USART_TypeDef            *USART;
#endif

#if _SPI
  EXT SPI_TypeDef              *SPI;
#endif

#if _ADC
  EXT ADC_TypeDef              *ADC;
#endif

#if _CMP_OP0
  EXT CMP_OP_TypeDef           *CMP_OP0;
#endif

#if _CMP_OP1
  EXT CMP_OP_TypeDef           *CMP_OP1;
#endif

#if _GPIOA
  EXT GPIO_TypeDef             *GPIOA;
#endif

#if _GPIOB
  EXT GPIO_TypeDef             *GPIOB;
#endif

#if _AFIO
  EXT AFIO_TypeDef             *AFIO;
#endif

#if _EXTI
  EXT EXTI_TypeDef             *EXTI;
#endif

#if _I2C
  EXT I2C_TypeDef              *I2C;
#endif

#if _WDT
  EXT WDT_TypeDef              *WDT;
#endif

#if _RTC
  EXT RTC_TypeDef              *RTC;
#endif

#if _PWRCU
  EXT PWRCU_TypeDef            *PWRCU;
#endif

#if _GPTM0
  EXT GPTM_TypeDef             *GPTM0;
#endif

#if _GPTM1
  EXT GPTM_TypeDef             *GPTM1;
#endif

#if _FLASH
  EXT FLASH_TypeDef            *FLASH;
#endif

#if _CKCU
  EXT CKCU_TypeDef             *CKCU;
#endif

#if _RSTCU
  EXT RSTCU_TypeDef            *RSTCU;
#endif

#endif /* DEBUG --------------------------------------------------------------------------------------------*/

#if (HT32F_LIB_DEBUG == 1)
/**
  * @brief  The assert_param macro is used for function's parameters check.
  * @param  expr: If expr is false, it calls assert_failed function
  *   which reports the name of the source file and the source
  *   line number of the call that failed.
  *   If expr is true, it returns no value.
  * @retval None
  */
#define Assert_Param(expr) ((expr) ? (void)0 : assert_error((u8 *)__FILE__, __LINE__))
/* Exported functions ------------------------------------------------------- ------------------------------*/
void assert_error(u8* file, u32 line);

#else

#define Assert_Param(expr) ((void)0)

#endif /* DEBUG --------------------------------------------------------------------------------------------*/


/* APB Peripherals                                                                                          */
#if _USART
  #include "ht32f125x_usart.h"
#endif

#if _SPI
  #include "ht32f125x_spi.h"
#endif

#if _ADC
  #include "ht32f125x_adc.h"
#endif

#if _CMP_OP
  #include "ht32f125x_cmp_op.h"
#endif

#if _GPIO
  #include "ht32f125x_gpio.h"
#endif

#if _EXTI
  #include "ht32f125x_exti.h"
#endif

#if _I2C
  #include "ht32f125x_i2c.h"
#endif

#if _WDT
  #include "ht32f125x_wdt.h"
#endif

#if _RTC
  #include "ht32f125x_rtc.h"
#endif

#if _PWRCU
  #include "ht32f125x_pwrcu.h"
#endif

#if _GPTM
  #include "ht32f125x_gptm.h"
#endif

/* AHB Peripherals                                                                                          */
#if _CKCU
  #include "ht32f125x_ckcu.h"
#endif

#if _RSTCU
  #include "ht32f125x_rstcu.h"
#endif

#if _FLASH
  #include "ht32f125x_flash.h"
#endif

/* Cortex-M3                                                                                                */
#if _MISC
  #include "ht32f125x_misc.h"
#endif

#if (_RETARGET)
  #if defined ( __GNUC__ )
    #undef getchar
    #define getchar SERIAL_GetChar
  #endif
  #include "ht32f125x_serial.h"
#endif

/* Exported types ------------------------------------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------------------------------------*/
/* Exported functions --------------------------------------------------------------------------------------*/
#if (HT32F_LIB_DEBUG == 1)
void debug(void);
#endif

#endif /* __HT32F125x_LIB_H --------------------------------------------------------------------------------*/
